﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using CashierCrisis.Entities;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.Managers
{
    public delegate void PauseDelegate(bool paused);

    public class EntityManager : DrawableGameComponent
    {
        private EntityPool _entityPool = new EntityPool(200);
        private List<Entity> _entities = new List<Entity>();
        private SpriteBatch _spriteBatch;

        private bool _paused = false;

        public EntityManager(Game game)
            : base(game)
        {
            _spriteBatch = game.Services.GetService(typeof(SpriteBatch)) as SpriteBatch;
            DrawOrder = 50;
        }

        public Entity GetEntity()
        {
            return _entityPool.Fetch();
        }

        public void AddEntity(Entity entity)
        {
            if (entity == null)
            {
                return;
            }
            _entities.Add(entity);
        }

        public void RemoveEntity(Entity entity)
        {
            _entities.Remove(entity);
            entity.Recycle();
        }

        public override void Update(GameTime gameTime)
        {
            if (!_paused)
            {
                for (int i = 0; i < _entities.Count; i++)
                {
                    _entities[i].Update(gameTime);
                }
            }
            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            for (int i = 0; i < _entities.Count; i++)
            {
                _spriteBatch.Begin(SpriteBlendMode.AlphaBlend);
                _entities[i].Draw(_spriteBatch);
                _spriteBatch.End();
            }
            base.Draw(gameTime);
        }

        public void Clear()
        {
            for (int i=(_entities.Count-1); i >=0 ; i--)
            {
                Entity e = _entities[i];
                _entityPool.Return(e);
                _entities.RemoveAt(i);
            }
        }

        public void Paused(bool paused)
        {
            _paused = paused;
        }
    }
}
